<?php
if (!defined('ABSPATH')) {
    exit();
}
if (!class_exists('CMCReviewNotice')) {
    class CMCReviewNotice
    {
        /**
         * The Constructor
         */
        public function __construct()
        {
            // register actions

            if (is_admin()) {
                add_action('admin_notices', array($this, 'atlt_admin_notice_for_reviews'));
                add_action('wp_ajax_atlt_dismiss_notice', array($this, 'atlt_dismiss_review_notice'));
                add_action('admin_enqueue_scripts', array($this, 'enqueue_review_notice_assets'));
            }
        }

        /**
         * Enqueue CSS and JS files for review notice
         */
        public function enqueue_review_notice_assets()
        {
            // Only enqueue on admin pages where the notice might show
            if (!current_user_can('update_plugins') || get_option('cmcc_spare_me')) {
                return;
            }

            // Check if we should show the notice based on installation time
            if (get_option('cmc_activation_time')) {
                $installation_date = date('Y-m-d h:i:s', get_option('cmc_activation_time'));
                $display_date = date('Y-m-d h:i:s');
                $install_date = new DateTime($installation_date);
                $current_date = new DateTime($display_date);
                $difference = $install_date->diff($current_date);
                $diff_days = $difference->days;

                if (isset($diff_days) && $diff_days >= 3) {
                    wp_enqueue_style('cmc-review-notice-css', CMC_URL . 'admin/feedback-notice/css/cmc-review-notice.css', array(), CMC);
                    wp_enqueue_script('cmc-review-notice-js', CMC_URL . 'admin/feedback-notice/js/cmc-review-notice.js', array('jquery'), CMC, true);
                }
            }
        }

        // ajax callback for review notice
        public function atlt_dismiss_review_notice()
        {
            check_ajax_referer('atlt_dismiss_notice_nonce', 'nonce');
            $rs = update_option('cmcc_spare_me', 'yes');
            echo json_encode(array("success" => "true"));
            exit;
        }
        // admin notice
        public function atlt_admin_notice_for_reviews()
        {

            if (!current_user_can('update_plugins')) {
                return;
            }
            if (get_option('cmc_activation_time')) {
                // get installation dates and rated settings
                $installation_date = date('Y-m-d h:i:s', get_option('cmc_activation_time'));
            }

            // check user already rated
            if (get_option('cmcc_spare_me')) {
                return;
            }

            // grab plugin installation date and compare it with current date
            $display_date = date('Y-m-d h:i:s');
            $install_date = new DateTime($installation_date);
            $current_date = new DateTime($display_date);
            $difference = $install_date->diff($current_date);
            $diff_days = $difference->days;

            // check if installation days is greator then week
            if (isset($diff_days) && $diff_days >= 3) {
                echo $this->atlt_create_notice_content();
            }
        }

        // generated review notice HTML
        public function atlt_create_notice_content()
        {

            $ajax_url = admin_url('admin-ajax.php');
            $ajax_callback = 'atlt_dismiss_notice';
            $wrap_cls = "notice notice-info is-dismissible";
            $img_path = CMC_URL . 'images/coinmarketcap-logo.png';
            $nonce = wp_create_nonce('atlt_dismiss_notice_nonce');
            $p_name = 'Coins MarketCap';
            $like_it_text = 'Rate Now! ★★★★★';
            $already_rated_text = esc_html__('Already Reviewed', 'atlt2');
            $not_like_it_text = esc_html__('Not Interested', 'atlt2');
            $p_link = esc_url('https://1.envato.market/CMCreviews');

         $message = "Thanks for using <b>" . esc_html($p_name) . "</b> - WordPress plugin.
        We hope you liked it ! <br/>Please give us a quick rating, it works as a boost for us to keep working on more <a href='https://coolplugins.net' target='_blank'><strong>Cool Plugins</strong></a>!<br/>";

            $html = '<div data-ajax-url="%8$s"  data-ajax-callback="%9$s" data-ajax-nonce="%11$s" class="cmc-feedback-notice-wrapper %1$s">
        <div class="message_container">%4$s
        <div class="callto_action">
        <ul>
            <li class="love_it"><a href="%5$s" class="like_it_btn button button-primary" target="_new" title="%6$s">%6$s</a></li>
            <li class="already_rated"><a href="javascript:void(0);" class="already_rated_btn button atlt_dismiss_notice" title="%7$s">%7$s</a></li>
            <li class="already_rated"><a href="javascript:void(0);" class="already_rated_btn button atlt_dismiss_notice" title="%10$s">%10$s</a></li>
        </ul>
        <div class="clrfix"></div>
        </div>
        </div>
        </div>';


            return sprintf($html,
                $wrap_cls,
                esc_url($img_path),
                esc_html($p_name),
                wp_kses_post($message),
                $p_link,
                esc_html($like_it_text),
                esc_html($already_rated_text),
                esc_url($ajax_url), // 8
                $ajax_callback, //9
                $not_like_it_text, //10
                $nonce

            );

        }

    } //class end

}
